package jamezo97.clonecraft.item;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.dna.ItemData;

import java.util.List;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

import org.lwjgl.input.Keyboard;

public class ItemTestTube extends Item{

	public ItemTestTube(int par1) {
		super(par1);
		setHasSubtypes(true);
		setTextureName("CloneCraft:testTube");
	}
	
	Icon blood, seperated, genes, mutating;
	
	@Override
	public void registerIcons(IconRegister ir) {
		super.registerIcons(ir);
		blood = ir.registerIcon("CloneCraft:testTubeBlood");
		seperated = ir.registerIcon("CloneCraft:testTubeSeperated");
		genes = ir.registerIcon("CloneCraft:testTubeGenes");
		mutating = ir.registerIcon("CloneCraft:mutatingGene");
	}
	


	@Override
	public ItemStack getContainerItemStack(ItemStack itemStack) {
		if(itemStack.getItemDamage() != 0){
			itemStack.setItemDamage(0);
			ItemData data = new ItemData(itemStack);
			data.drain();
			return itemStack;
		}
		return super.getContainerItemStack(itemStack);
	}

	@Override
	public int getColorFromItemStack(ItemStack par1ItemStack, int par2) {
		if(par2 != 0 && par1ItemStack.getItemDamage() != 0){
			return new ItemData(par1ItemStack).getColour();
		}
		return 0xffffff;
	}
	
    @Override
	public String getItemDisplayName(ItemStack stack) {
    	ItemData dna = new ItemData(stack);
    	String type = null;
    	String prefix = "";
    	switch(stack.getItemDamage()){
    	case 1: type = "Blood"; break;
    	case 2: prefix = "Seperated "; type = "Blood"; break;
    	case 3: type = "Genes"; break;
    	case 4: prefix = "Mutating "; type = "Bacteria"; break;
    	}
    	return dna.getDisplayName("TestTube", type, prefix, stack	);
	}
    
	@Override
	public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
		new ItemData(par1ItemStack).addInfo(par3List, Keyboard.isKeyDown(Keyboard.KEY_LSHIFT));
	}
    
	@Override
	public Icon getIcon(ItemStack stack, int pass) {
		if(stack.getItemDamage() == 0){
			return itemIcon;
		}else{
			if(pass == 0){
				return itemIcon;
			}else{
				if(stack.getItemDamage() == 1){
					return blood;
				}else if(stack.getItemDamage() == 2){
					return seperated;
				}else if(stack.getItemDamage() == 3){
					return genes;
				}else if(stack.getItemDamage() == 4){
					return mutating;
				}else{
					return itemIcon;
				}
			}
		}
	}

	@Override
	public boolean requiresMultipleRenderPasses() {
		return true;
	}
	
    public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List)
    {
/*    	ItemData dna = new ItemData();
    	dna.addEntity(CloneCraft.cloneId);
    	NBTTagCompound nbt = dna.save();
    	
    	par3List.add(new ItemStack(par1, 1, 0));
    	
    	ItemStack s2 = new ItemStack(par1, 1, 1);
    	s2.setTagCompound(nbt);
    	par3List.add(s2);
    	
    	ItemStack s3 = new ItemStack(par1, 1, 2);
    	s3.setTagCompound(nbt);
    	par3List.add(s3);*/
    	
    	ItemData data = new ItemData();
    	data.setEntity(CloneCraft.cloneId);
    	NBTTagCompound nbt = data.saveToNbt();
    	
    	par3List.add(new ItemStack(par1, 1, 0));
    	
    	ItemStack s2 = new ItemStack(par1, 1, 1);
    	s2.setTagCompound(nbt);
    	par3List.add(s2);
    	
    	ItemStack s3 = new ItemStack(par1, 1, 2);
    	s3.setTagCompound(nbt);
    	par3List.add(s3);
    	
    	int[] allGenes = Gene.getAllGeneIds();
    	
    	for(int a = 0; a < allGenes.length; a++){
    		ItemStack gene = new ItemStack(itemID, 1, 3);
    		new ItemData(gene).setGene(allGenes[a]).save();
    		par3List.add(gene);
    	}
    	
    	ItemStack s4 = new ItemStack(par1, 1, 4);
    	par3List.add(s4);
    }
	

}
